ManureFix = {}
ManureFix.Debug = false;

ManureFix.modDir = g_currentModDirectory;


function ManureFix:formatVolume(liters, precision, unit)
    unit = unit ~= "" and (unit == false and "" or unit) or nil
    return g_i18n:formatVolume(liters, precision, unit)
end

function ManureFix:formatCapacity(liters, capacity, precision, unit)
    return self:formatVolume(liters, precision, false) .. " / " .. self:formatVolume(capacity, precision, unit);
end

function ManureFix:updateInfoPlaceableManureHeap(_, superFunc, infoTable)
    superFunc(self, infoTable)

    local spec = self.spec_manureHeap

    if spec.manureHeap == nil then
        return
    end

    if self.spec_husbandryStraw ~= nil then
        return
    end

    local fillLevel = spec.manureHeap:getFillLevel(spec.manureHeap.fillTypeIndex);
    local capacity = spec.manureHeap:getCapacity(spec.manureHeap.fillTypeIndex);
    spec.infoFillLevel.text = ManureFix:formatCapacity(fillLevel, capacity, 0, nil, g_fillTypeManager:getFillTypeNameByIndex(spec.manureHeap.fillTypeIndex));

    table.insert(infoTable, spec.infoFillLevel)

    table.insert(infoTable,
        {
            title = g_i18n:getText("manureFix_MANURE_HEAP_CONNECTED"),
            accentuate = true
        }
    )

    for j, unloadingStation in pairs (spec.manureHeap.unloadingStations) do
        table.insert(infoTable, {
            title = "",
            text = unloadingStation:getName()
        })
    end	
end
PlaceableManureHeap.updateInfo = Utils.overwrittenFunction(PlaceableManureHeap.updateInfo, ManureFix.updateInfoPlaceableManureHeap)

function ManureFix:getDetiServer()
    return g_server ~= nil and g_client ~= nil and g_dedicatedServer ~= nil;
end;

addModEventListener(ManureFix)
