-- Author:RedFoxModding
-- Name:SeedbedReconsolidation
-- Version: 1.0.0.0
-- Development: Jun.22
-- Date: 24.06.2022

SeedbedReconsolidation = {}

function SeedbedReconsolidation.prerequisitesPresent(specializations)
    return SpecializationUtil.hasSpecialization(SowingMachine, specializations)
end

function SeedbedReconsolidation.registerOverwrittenFunctions(vehicleType)
    SpecializationUtil.registerOverwrittenFunction(vehicleType, "processSowingMachineArea", SeedbedReconsolidation.processSowingMachineArea)
end

function SeedbedReconsolidation:processSowingMachineArea(superFunc, workArea, dt)
	
	local spec = self.spec_sowingMachine
	local xs, _, zs = getWorldTranslation(workArea.start)
	local xw, _, zw = getWorldTranslation(workArea.width)
	local xh, _, zh = getWorldTranslation(workArea.height)
	local _, _ = FSDensityMapUtil.updateRollerArea(xs, zs, xw, zw, xh, zh, spec.workAreaParameters.angle)
	
	local realArea, area = superFunc(self, workArea, dt)
	return realArea, area
end
