CutBale = {};

source(g_currentModDirectory.."CutBaleEvent.lua");

function CutBale:CutBaleActionButton()
	if CutBale.CutTarget == nil then
		return
	end

    local FillLevel = CutBale.CutTarget.fillLevel;
    local FillType = CutBale.CutTarget.fillType;
    local x, y, z = getTranslation(CutBale.CutTarget.nodeId);    

    local farmlandId = g_farmlandManager:getFarmlandIdAtWorldPosition(x, z);
    if farmlandId ~= nil then farmlandId = g_farmlandManager:getFarmlandOwner(farmlandId) end;

    if farmlandId ~= 0 and g_currentMission.accessHandler:canFarmAccessOtherId(g_localPlayer:getFarmId(), farmlandId) and DensityMapHeightUtil.getCanTipToGroundAroundLine(nil, FillLevel, FillType, x, y, z, x + 3 , y, z + 3 , 10, 40, 0, false, nil, nil) then     
		CutBale.CutTarget:delete();
        g_client:getServerConnection():sendEvent(CutBaleEvent.new(FillLevel, FillType, x, y, z));
        return;
    end;
    
    g_currentMission:showBlinkingWarning(g_i18n:getText("warning_youDontHaveAccessToThisLand"), 2000);
end

PlayerInputComponent.registerGlobalPlayerActionEvents = Utils.appendedFunction(PlayerInputComponent.registerGlobalPlayerActionEvents, function()
    if CutBale.ActionId == nil then
        local Valid, Id = g_inputBinding:registerActionEvent(InputAction.CutBaleAction, "CutBaleAction", CutBale.CutBaleActionButton, false, true, false, false);
        if Valid then 
            CutBale.ActionId = Id;
            
        end
    end
end)

function CutBale:UpdateActionEvents()
    if CutBale.ActionId ~= nil then	
        g_inputBinding:setActionEventTextPriority(CutBale.ActionId, GS_PRIO_VERY_HIGH)
        g_inputBinding:setActionEventActive(CutBale.ActionId, CutBale.CutTarget ~= nil);
	end
end

function CutBale:update()

	CutBale.CutTarget = nil;

	if g_localPlayer:getCurrentVehicle() == nil and g_localPlayer:getIsControlled() then
		local x, y, z = localToWorld(g_localPlayer.camera.cameraRootNode, 0, 0, 1.0)
		local dx, dy, dz = localDirectionToWorld(g_localPlayer.camera.cameraRootNode, 0, 0, -1)
		raycastAll(x, y, z, dx, dy, dz, 3, "RaycastCallback", self);
	end

    if CutBale.CutTarget ~= nil and CutBale.CutTarget.fillType == FillType.COTTON then CutBale.CutTarget = nil; end

	CutBale:UpdateActionEvents()
end;

function CutBale:RaycastCallback(hitObjectId)
    for _, SaveItem in pairs (g_currentMission.itemSystem.itemsToSave) do  
        if SaveItem.item.isMissionBale ~= nil and SaveItem.item.nodeId == hitObjectId and SaveItem.item:getOwnerFarmId() == g_localPlayer:getFarmId() then
            CutBale.CutTarget = SaveItem.item;
            return false;
        end;
    end

    return true
end

function CutBale:TipToGround(amount, fillTypeIndex, x, y, z, player)
    local length = 3;
    local dirX = 1;
    local dirZ = 1;

    local tipped, lineOffset = DensityMapHeightUtil.tipToGroundAroundLine(nil, amount, fillTypeIndex, x, y, z, x + length * dirX, y, z + length * dirZ, 10, 40, 0, false, nil, nil, true)

    local Px, Py, Pz = getWorldTranslation(player.rootNode)
    local Height = DensityMapHeightUtil.getHeightAtWorldPos(Px, Py, Pz)
    player.mover:teleportTo(Px, Height + 0.1, Pz)
end;

addModEventListener(CutBale);