--print("!!!! AEP FILE LOADED (Stage-aware loadMotor) !!!!")

adjustEnginePower = {}
TypeClass = adjustEnginePower

adjustEnginePower.MOD_NAME  = g_currentModName
adjustEnginePower.MOD_DIR   = g_modNameToDirectory[g_currentModName]
adjustEnginePower.SPEC_NAME = "adjustEnginePower"

-----------------------------------------------------------------------
-- Boost-Stufen aus boostConfigurations.xml
-----------------------------------------------------------------------
local boostCache = {}

local function loadBoosts()
    if next(boostCache) ~= nil then return end

    local xmlPath = adjustEnginePower.MOD_DIR .. "boostConfigurations.xml"
    local xml = loadXMLFile("aepBoosts", xmlPath)
    if xml == 0 then
        print("[AEP] Boost-XML NICHT gefunden:", xmlPath)
        return
    end

    local i = 0
    while true do
        local key = string.format("boostConfigurations.boost(%d)", i)
        if not hasXMLProperty(xml, key) then break end

        local id    = getXMLInt(xml,   key.."#id")    or (i+1)
        local boost = getXMLFloat(xml, key.."#boost") or 0

        boostCache[id] = boost
        i = i + 1
    end

    delete(xml)
    --print("[AEP] Boost-Konfigurationen geladen:", i, "Einträge")
end

local function getBoostForConfigIndex(idx)
    loadBoosts()
    return boostCache[idx] or 0
end

-----------------------------------------------------------------------
-- Spezialisierungs-Interface
-----------------------------------------------------------------------
function adjustEnginePower.prerequisitesPresent(specializations)
    return SpecializationUtil.hasSpecialization(Motorized, specializations)
end

function adjustEnginePower.registerEventListeners(vehicleType)
    -- wie im funktionierenden Global-Mod: in onPreLoad einhängen
    SpecializationUtil.registerEventListener(vehicleType, "onPreLoad", adjustEnginePower)
end

-----------------------------------------------------------------------
-- Vor dem Motor-Laden: loadMotor hooken
-----------------------------------------------------------------------
function adjustEnginePower:onPreLoad()
    if self.loadMotor ~= nil then
        self.loadMotor = Utils.overwrittenFunction(self.loadMotor, adjustEnginePower.loadMotor)
        -- Debug falls nötig:
        -- print("[AEP] loadMotor gehookt für:", self.configFileName or "unknown")
    end
end

-----------------------------------------------------------------------
-- Motor laden & torqueScale je nach Shop-Stufe hochdrehen
-----------------------------------------------------------------------
function adjustEnginePower:loadMotor(superFunc, xmlFile, motorId)
    -------------------------------------------------------------------
    -- 1) Stage aus Shop-Konfiguration lesen
    -------------------------------------------------------------------
    local cfgIndex = 1
    if self.configurations ~= nil and self.configurations["adjustEnginePower"] ~= nil then
        cfgIndex = self.configurations["adjustEnginePower"]
    end

    local boost  = getBoostForConfigIndex(cfgIndex) or 0
    local factor = 1 + boost

    -------------------------------------------------------------------
    -- 2) Motor-Konfiguration im XML finden (wie im Global-Mod)
    -------------------------------------------------------------------
    local fallbackConfigKey = "vehicle.motorized.motorConfigurations.motorConfiguration(0)"
    local key

    key, motorId = ConfigurationUtil.getXMLConfigurationKey(
        xmlFile,
        motorId,
        "vehicle.motorized.motorConfigurations.motorConfiguration",
        "vehicle.motorized",
        "motor"
    )

    -------------------------------------------------------------------
    -- 3) torqueScale erhöhen, wenn Boost > 0
    -------------------------------------------------------------------
    if key ~= nil and boost > 0 then
        local torqueScaleBefore = ConfigurationUtil.getConfigurationValue(
            xmlFile,
            key,
            ".motor",
            "#torqueScale",
            1,
            fallbackConfigKey
        )

        local torqueScaleAfter = torqueScaleBefore * factor

        if xmlFile.setValue ~= nil then
            xmlFile:setValue(key .. ".motor#torqueScale", torqueScaleAfter)
        elseif xmlFile.setFloat ~= nil then
            xmlFile:setFloat(key .. ".motor#torqueScale", torqueScaleAfter)
        end

        --print(string.format(
        --    "[AEP] %s: Stage=%d Boost=%.0f%% torqueScale %.3f -> %.3f",
        --    self.configFileName or "unknown",
        --    cfgIndex,
        --    boost * 100,
        --    torqueScaleBefore,
        --    torqueScaleAfter
        --))
    else
        -- optionales Debug:
        -- print(string.format("[AEP] %s: kein Boost (Stage=%d, boost=%.2f, key=%s)",
        --     self.configFileName or "unknown", cfgIndex, boost, tostring(key)))
    end

    -------------------------------------------------------------------
    -- 4) Original-Funktion aufrufen
    -------------------------------------------------------------------
    return superFunc(self, xmlFile, motorId)
end
